How to use:

1. Create a virtualenv

```
python3 -m venv .venv
```

2. Activate it:

For Windows PowerShell (recommended):

```powershell
# If you haven't previously, allow running local scripts for the session (optional)
# You can run this once per session; it does not change system policy permanently:
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope Process -Force

# Activate the virtual environment
.\.venv\Scripts\Activate.ps1
```

For Command Prompt (cmd.exe):

```cmd
.venv\Scripts\activate.bat
```

For Unix/macOS shells (bash/zsh):

```bash
source .venv/bin/activate
```

3. Install required Python packages

```powershell
# Create or update a minimal requirements.txt first if not present
pip install --upgrade pip
pip install -r requirements.txt

# If you don't have a requirements.txt, a recommended set is:
pip install pandas numpy matplotlib seaborn scipy jupyterlab
```

4. Running the notebook

Open the notebook with Jupyter (recommended) or JupyterLab:

```powershell
jupyter notebook noise.ipynb
# or
jupyter lab
```

Then open `noise.ipynb` in the browser and run the cells in order. The notebook:
- Loads `data.txt` (TSV with `timestamp` and `current`).
- Cleans and parses timestamps and numeric values.
- Computes sampling stats, applies a high-pass filter (Butterworth via SciPy if available,
  otherwise a rolling-mean subtraction fallback), and computes PSDs and RMS for the
  whole dataset and for shielded vs unshielded halves.

5. Notes and troubleshooting
- If SciPy is not installed the notebook will automatically fall back to the rolling-mean method.
- If you get an error about execution policy when activating the venv in PowerShell, run:

```powershell
Set-ExecutionPolicy -ExecutionPolicy RemoteSigned -Scope Process -Force
```

- To reproduce precise results or to run headless analysis (no GUI), you can run the notebook via nbconvert:

```powershell
jupyter nbconvert --to notebook --execute noise.ipynb --output executed_noise.ipynb
```

That's it — open the notebook and run the cells. If you want, I can also generate a ready-made
`requirements.txt` from the environment (I can run pip freeze and save the file) or add a small
CLI script to compute noise metrics from the `data.txt` file.

