def parse_record(record):
    # split the record into fields, separated by commas
    messages = record.split(',')
    return [parse_message(m) for m in messages]

def parse_message(message):
    flags = {
        'N': False,
        'O': False,
        'S': False,
        'Z': False,
        'M': False,
    }
    mode = None
    value= None
    meas=None
    # message contains 1 or more flags indicating message type
    # N normal O overload S source Z suppressed M measurement
    # then either DC, SW(eep) or PL (pulse)
    # then either I (current ) or V (voltage)
    # then scientific notation number
    # extract the mode and its position:
    for i, c in enumerate(message):
        if c in flags:
            flags[c] = True
        elif c in ['B', 'T']:  # DC, SW, PL
            mode = c
            mode_pos = i
            break
        elif c in ['D', 'S', 'P' ]:  # DC, SW, PL
            mode = c
            meas = message[i+2]
            mode_pos = i+2
            break
    #the rest of the message is the numeric value
    if mode:
        value = message[mode_pos + 1:]  # skip the next char (I or V)
    value = float(value) if value else None
    return flags, mode, value, meas



